/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.ars_nouveau.index.DocValues;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.NumericDocValues;
import org.apache.lucene.ars_nouveau.queries.function.FunctionValues;
import org.apache.lucene.ars_nouveau.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.ars_nouveau.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.ars_nouveau.search.SortField;

public class FloatFieldSource
extends FieldCacheSource {
    public FloatFieldSource(String field) {
        super(field);
    }

    @Override
    public String description() {
        return "float(" + this.field + ")";
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortField(this.field, SortField.Type.FLOAT, reverse);
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = this.getNumericDocValues(context, readerContext);
        return new FloatDocValues(this, this){
            int lastDocID;

            @Override
            public float floatVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    return Float.intBitsToFloat((int)arr.longValue());
                }
                return 0.0f;
            }

            @Override
            public boolean exists(int doc) throws IOException {
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                this.lastDocID = doc;
                int curDocID = arr.docID();
                if (doc > curDocID) {
                    curDocID = arr.advance(doc);
                }
                return doc == curDocID;
            }
        };
    }

    protected NumericDocValues getNumericDocValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        return DocValues.getNumeric(readerContext.reader(), this.field);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != FloatFieldSource.class) {
            return false;
        }
        FloatFieldSource other = (FloatFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = Float.class.hashCode();
        return h += super.hashCode();
    }
}

